<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class SecretariaUnidade extends Model
{
    use HasFactory;

    protected $table = 'secretaria_unidades';

    protected $fillable = [
        'nome',
        'horario_atendimento',
        'endereco',
        'telefone',
        'email',
        'secretarias_id',
    ];

    public function secretaria()
    {
        return $this->belongsTo(Secretarias::class, 'secretarias_id');
    }
}
