<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Str;

class Noticia extends Model
{
    use HasFactory;

    protected $table = 'noticias';

    protected $fillable = [
        'titulo',
        'subtitulo',
        'slug',
        'texto',
        'capa',
        'secretarias_id',
    ];

    // Secretaria (opcional)
    protected static function booted()
    {
        static::saving(function (Noticia $model) {
            if (blank($model->slug) && filled($model->titulo)) {
                $model->slug = Str::slug($model->titulo);
            }
        });
    }
    public function secretaria()
    {

        return $this->belongsToMany(
            Secretarias::class,
            'noticia_scretarias',   // tabela pivot
            'noticias_id',           // FK desta tabela
            'secretarias_id'           // FK da outra tabela
        )->withTimestamps();
    }

    // Categorias (M:N)
    public function categorias()
    {
        return $this->belongsToMany(
            Categoria::class,
            'noticias_categorias',   // tabela pivot
            'noticias_id',           // FK desta tabela
            'categoria_id'           // FK da outra tabela
        )->withTimestamps();
    }

    public function imagens()
    {
        return $this->hasMany(\App\Models\GaleriaImagens::class, 'noticias_id');
    }
}
