<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Eventos extends Model
{
    protected $fillable = [
        'nome',
        'status',
        'capa',
        'data_hora_inicio',
        'data_hora_fim',
        'descricao',
        'slug',
        'visualizacoes',
    ];
    public function secretaria()
    {
        return $this->belongsToMany(
            Secretarias::class,
            'eventos_secretarias',   // tabela pivot
            'evento_id',           // FK desta tabela
            'secretarias_id'           // FK da outra tabela
        )->withTimestamps();
    }

      public function imagens()
    {
        return $this->hasMany(\App\Models\EventoGaleria::class, 'evento_id');
    }
}
