<?php

namespace App\Filament\Resources;

use App\Filament\Resources\SecretariasResource\Pages;
use App\Filament\Resources\SecretariasResource\RelationManagers;
use App\Models\Secretarias;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Support\Enums\FontFamily;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;

class SecretariasResource extends Resource
{
    protected static ?string $model = Secretarias::class;
    protected static ?string $navigationGroup = 'Administração';
    protected static ?string $navigationIcon = 'heroicon-o-building-office';

    public static function form(Form $form): Form
    {
        return $form
            ->schema([

                Forms\Components\FileUpload::make('foto_secretario')
                    ->image()
                    ->imageEditor(),
                Forms\Components\TextInput::make('nome')
                    ->required()
                    ->label('Nome da Secretaria')
                    ->maxLength(150),
                Forms\Components\TextInput::make('nome_secretario')
                    ->required()
                    ->label('Nome do Secretario')
                    ->maxLength(150),
                Forms\Components\TextInput::make('email_secretaria')
                    ->email()
                    ->required()
                    ->maxLength(150),

                Forms\Components\TextInput::make('horario_funcionamento')
                    ->required()
                    ->maxLength(150),
                Forms\Components\TextInput::make('telefone')
                    ->tel()
                    ->telRegex('/^[+]*[(]{0,1}[0-9]{1,4}[)]{0,1}[-\s\.\/0-9]*$/'),
                Forms\Components\RichEditor::make('descricao')
                    ->columnSpanFull(),
                Forms\Components\TextInput::make('endereco')
                    ->required()
                    ->label('Endereço')
                    ->maxLength(250),

            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                Tables\Columns\ImageColumn::make('foto_secretario')
                    ->circular()
                    ->searchable(),
                Tables\Columns\TextColumn::make('nome')
                    ->label('Nome da Secretaria')
                    ->searchable(),
                Tables\Columns\TextColumn::make('nome_secretario')
                    ->label('Nome do Secretario')
                    ->searchable(),
                Tables\Columns\TextColumn::make('email_secretaria')
                    ->label('Email da Secretaria')
                    ->icon('heroicon-m-envelope')
                    ->iconColor('primary')
                    ->copyable()
                    ->copyMessage('Email copiado')
                    ->copyMessageDuration(1500)
                    ->fontFamily(FontFamily::Mono)
                    ->searchable(),
                Tables\Columns\TextColumn::make('endereco')
                    ->label('Endereço da Secretaria')
                    ->searchable(),
                Tables\Columns\TextColumn::make('horario_funcionamento')
                    ->searchable(),
                Tables\Columns\TextColumn::make('telefone')
                    ->searchable(),

                Tables\Columns\TextColumn::make('latitude')
                    ->searchable(),
                Tables\Columns\TextColumn::make('longitude')
                    ->searchable(),
                Tables\Columns\TextColumn::make('created_at')
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
                Tables\Columns\TextColumn::make('updated_at')
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
            ])
            ->filters([
                //
            ])
            ->actions([
                Tables\Actions\EditAction::make(),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            RelationManagers\UnidadesRelationManager::class,
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListSecretarias::route('/'),
            'create' => Pages\CreateSecretarias::route('/create'),
            'edit' => Pages\EditSecretarias::route('/{record}/edit'),
        ];
    }
}
