<?php

namespace App\Filament\Resources;

use App\Filament\Resources\EventosResource\Pages;
use App\Filament\Resources\EventosResource\RelationManagers;
use App\Models\Eventos;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Forms\Get;
use Filament\Forms\Set;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;
use Illuminate\Support\Str;

class EventosResource extends Resource
{
    protected static ?string $model = Eventos::class;
    protected static ?string $navigationGroup = 'Conteúdo';
    protected static ?string $navigationIcon = 'heroicon-o-rectangle-stack';

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                Forms\Components\Group::make([
                    Forms\Components\FileUpload::make('capa')
                        ->label('Capa')
                        ->image()
                        ->disk('public')
                        ->directory('evento/capas')
                        ->imageEditor()
                        ->downloadable(),
                ])->columnSpanFull(),

                Forms\Components\TextInput::make('nome')
                    ->required()
                    ->live(onBlur: true) // só dispara quando sai do campo
                    ->afterStateUpdated(function (string $state, Set $set, Get $get) {
                        // Preenche o slug apenas se ainda estiver vazio
                        if (blank($get('slug')) && filled($state)) {
                            $set('slug', Str::slug($state));
                        }
                    })
                    ->maxLength(255),
                Forms\Components\Select::make('status')
                    ->label('Status do Evento')
                    ->options(['pendente', 'em_andamento','concluido','cancelado']) // Filament entende enums nativamente
                    ->required(),
                Forms\Components\DateTimePicker::make('data_hora_inicio')
                    ->required(),
                Forms\Components\DateTimePicker::make('data_hora_fim')
                    ->required(),
                Forms\Components\RichEditor::make('descricao')
                    ->required()
                    ->columnSpanFull(),
                Forms\Components\TextInput::make('slug')
                    ->required()
                    ->maxLength(255),
                Forms\Components\Select::make('secretarias_id')
                    ->label('Secretaria')
                    ->relationship(name: 'secretaria', titleAttribute: 'nome') // usa belongsTo
                    ->searchable()
                    ->preload()
                    ->required(),
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                Tables\Columns\TextColumn::make('nome')
                    ->searchable(),
                Tables\Columns\TextColumn::make('status'),
                Tables\Columns\TextColumn::make('data_hora_inicio')
                    ->dateTime()
                    ->sortable(),
                Tables\Columns\TextColumn::make('data_hora_fim')
                    ->dateTime()
                    ->sortable(),
                Tables\Columns\TextColumn::make('slug')
                    ->searchable(),
                Tables\Columns\TextColumn::make('visualizacoes')
                    ->numeric()
                    ->sortable(),
                Tables\Columns\TextColumn::make('created_at')
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
                Tables\Columns\TextColumn::make('updated_at')
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
            ])
            ->filters([
                //
            ])
            ->actions([
                Tables\Actions\EditAction::make(),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListEventos::route('/'),
            'create' => Pages\CreateEventos::route('/create'),
            'edit' => Pages\EditEventos::route('/{record}/edit'),
        ];
    }
}
