<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\MenuController;
use App\Http\Controllers\SecretariasController;
use App\Http\Controllers\NoticiaController;
use App\Http\Controllers\VideosController;

Route::get('/user', function (Request $request) {
    return $request->user();
})->middleware('auth:sanctum');

Route::get('/menu', [MenuController::class, 'index']);
Route::get('/secretarias', [SecretariasController::class, 'index']);
Route::get('/noticias', [NoticiaController::class, 'index']);
Route::get('/noticias/listagem', [NoticiaController::class, 'list']);
Route::get('/noticia/{slug}', [NoticiaController::class, 'slug']);

Route::get('/videos', [VideosController::class, 'index']);
Route::get('/videos/listagem', [VideosController::class, 'list']);
Route::get('/video/{slug}', [VideosController::class, 'slug']);
