<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class TipoSituacaoSeed extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $now = now();

        $nomes = [
            'Aberto',
            'Suspenso',
            'Anulado',
            'Revogado',
            'Em Julgamento',
            'Concluído',
            'Homologado',
            'Adiado',
            'Em Andamento',
            'Redesignado',
            'Deserta',
            'Adjudicado',
            'Fracasada',   // conforme o print
            'Retificado',
            'Ratificado',
            'Ratificada',
            'Cancelada',
        ];

        foreach ($nomes as $nome) {
            DB::table('tipo_situacao')->updateOrInsert(
                ['nome' => $nome], // evita duplicar caso rode mais de uma vez
                ['created_at' => $now, 'updated_at' => $now]
            );
        }
    }
}
