<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class TipoArquivosSeed extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $now = now();

        $items = [
            ['nome' => 'Impugnações'],
            ['nome' => 'Recursos'],
            ['nome' => 'Pareceres Jurídicos'],
            ['nome' => 'Pareceres da Controladoria Interna'],
            ['nome' => 'Atas'],
            ['nome' => 'Adjudicações'],
            ['nome' => 'Homologações'],
            ['nome' => 'Ata de Registro de Preços'],
            ['nome' => 'Extratos Contratuais'],
            ['nome' => 'Extratos de Termos Aditivos'],
            ['nome' => 'Execução Contratual'],
            ['nome' => 'Proposta'],
            ['nome' => 'Retificações'],
            ['nome' => 'Memorial descritivo'],
            ['nome' => 'Minuta da proposta'],
            ['nome' => 'Minuta de contrato'],
            ['nome' => 'Cronograma'],
            ['nome' => 'Planta'],
            ['nome' => 'Planilha'],
            ['nome' => 'Comprovante'],
            ['nome' => 'Declaração'],
            ['nome' => 'Anexos'],
            ['nome' => 'Propostas'],
            ['nome' => 'Cotação'],
            ['nome' => 'Planilha de Proposta'],
            ['nome' => 'Aviso de Contratação Direta'],
            ['nome' => 'Edital'],
            ['nome' => 'Minuta do Contrato'],
            ['nome' => 'Termo de Referência'],
            ['nome' => 'Projeto Básico'],
            ['nome' => 'Anteprojeto'],
            ['nome' => 'Projeto Técnico Preliminar'],
            ['nome' => 'Projeto Executivo'],
            ['nome' => 'Mapa de Riscos'],
            ['nome' => 'DDX'],
            ['nome' => 'Minuta de Ata de Registro de Preços'],
        ];

        foreach ($items as $item) {
            DB::table('tipo_arquivo')->updateOrInsert(
                ['nome' => $item['nome']], // evita duplicado
                ['created_at' => $now, 'updated_at' => $now]
            );
        }
    }
}
