<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('arquivos_licitacao', function (Blueprint $table) {
            $table->id();
             $table->string('link'); // caminho/arquivo
            $table->text('descricao')->nullable();

            // status: no diagrama está TINYBLOB; usando tinyInteger como status lógico
            $table->tinyInteger('status')->default(1); // 1=ativo, 0=inativo (ajuste conforme sua regra)

            $table->foreignId('licitacao_id')
                  ->constrained('licitacao')
                  ->cascadeOnUpdate()
                  ->cascadeOnDelete();

            $table->foreignId('tipo_arquivo_id')->nullable()
                  ->constrained('tipo_arquivo')
                  ->cascadeOnUpdate()
                  ->nullOnDelete();

            $table->timestamps();

            $table->index('tipo_arquivo_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('arquivos_licitacao');
    }
};
