<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('noticias', function (Blueprint $table) {
            $table->id();
            $table->string('titulo', 255);
            $table->string('subtitulo', 255)->nullable();
            $table->string('slug', 255)->unique();
            $table->longText('texto')->nullable();
            $table->string('capa', 200)->nullable();
            $table->integer('visualizacoes')->default(1);
            // FK para secretarias (já criada anteriormente)


            $table->timestamps();
        });


    }



    public function down(): void
    {
        Schema::dropIfExists('noticias');


    }
};
