<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('secretaria_unidades', function (Blueprint $table) {
            $table->id();
            $table->string('nome');
            $table->string('horario_atendimento' )->nullable();
            $table->string('endereco')->nullable();
            $table->string('telefone')->nullable();
            $table->string('email')->nullable();

            // FK para secretarias(id)
            $table->unsignedBigInteger('secretarias_id');
            $table->foreign('secretarias_id')
                ->references('id')->on('secretarias')
                ->onUpdate('cascade')
                ->onDelete('cascade');

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('secretaria_unidades');
    }
};
