<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Videos extends Model
{
    protected $fillable = ['titulo','link','descricao','capa','visualizacoes','slug'];

    public function categorias()
    {
        return $this->belongsToMany(
            Categoria::class,
            'video_categorias',   // tabela pivot
            'video_id',           // FK desta tabela
            'categoria_id'           // FK da outra tabela
        )->withTimestamps();
    }
}
