<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class NoticiaCategoria extends Model
{
    use HasFactory;

    protected $table = 'noticias_categorias';

    protected $fillable = [
        'noticias_id',
        'categoria_id',
    ];

    public function noticia()
    {
        return $this->belongsTo(Noticia::class, 'noticias_id');
    }

    public function categoria()
    {
        return $this->belongsTo(Categoria::class, 'categoria_id');
    }
}
