<?php

namespace App\Http\Controllers;

use App\Models\Noticia;
use Biostate\FilamentMenuBuilder\Models\Menu;
use Illuminate\Http\Request;

class NoticiaController extends Controller
{
    public function index(Request $request){

        $offset = $request->query('offset', 0);  // valor padrão = 0
        $limit  = $request->query('limit', 10);  // valor padrão = 10

        $noticias = Noticia::with(['secretaria', 'imagens', 'categorias'])
            ->skip($offset)
            ->take($limit)
            ->get();
        return $noticias;

    }

    public function list(Request $request){
        return Noticia::with('secretaria','imagens','categorias')->paginate();
    }



    public function slug($slug){
        $noticia = Noticia::with(['secretaria', 'imagens', 'categorias'])
            ->where('slug', $slug)
            ->firstOrFail();

        $noticia->increment('visualizacoes');

        return $noticia;
    }
}
