<?php

namespace App\Filament\Resources\SecretariasResource\RelationManagers;

use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\RelationManagers\RelationManager;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;

class UnidadesRelationManager extends RelationManager
{
    protected static string $relationship = 'unidades'; // método no Model Secretaria

    protected static ?string $title = 'Unidades';

    public function form(Form $form): Form
    {
        return $form->schema([
            Forms\Components\TextInput::make('nome')
                ->label('Nome')
                ->maxLength(45)
                ->required(),
            Forms\Components\TextInput::make('horario_atendimento')
                ->label('Horário de Atendimento')
                ->maxLength(150),
            Forms\Components\TextInput::make('endereco')
                ->label('Endereço')
                ->maxLength(150),
            Forms\Components\TextInput::make('telefone')
                ->label('Telefone')
                ->maxLength(150),
            Forms\Components\TextInput::make('email')
                ->label('E-mail')
                ->email()
                ->maxLength(100),
        ]);
    }

    public function table(Table $table): Table
    {
        return $table
            ->columns([
                Tables\Columns\TextColumn::make('nome')->label('Nome')->searchable()->sortable(),
                Tables\Columns\TextColumn::make('horario_atendimento')->label('Horário'),
                Tables\Columns\TextColumn::make('endereco')->label('Endereço')->wrap(),
                Tables\Columns\TextColumn::make('telefone')->label('Telefone'),
                Tables\Columns\TextColumn::make('email')->label('E-mail'),
            ])
            ->headerActions([
                Tables\Actions\CreateAction::make(), // cria unidade já vinculada à secretaria
            ])
            ->actions([
                Tables\Actions\EditAction::make(),
                Tables\Actions\DeleteAction::make(),
            ])
            ->bulkActions([
                Tables\Actions\DeleteBulkAction::make(),
            ]);
    }
}
